/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.KeepAliveTasklet;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.task.TaskLauncher;
import com.ibm.hwmca.fw.tasklet.PanelTask;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletClientExitInterface;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;

public class AsyncTask
extends PanelTask
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMASTT";
    private static final String TRACE_MASKF = "XFRMASTF";
    private static final String TRACE_MASKD = "XFRMASTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "AsyncTask");
    private static final int TYPE_LOCAL = 1;
    private static final int TYPE_TASKLET = 2;
    private static final int TYPE_ALLSESSIONS = 3;
    public static final String ASYNC_TASK_OBJECT_KEY = "Async_Task_Object_Key";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$task$AsyncTask;

    public static void startLocalTask(String taskletClassName, LocalizableText title, Object object) throws IllegalStateException, HException {
        Trace.trace(TRACE_MASKT, "-> AsyncTask.startLocalTask()");
        Tasklet keepalive = KeepAliveTasklet.tasklet;
        if (keepalive != null) {
            AsyncTaskExit exit = new AsyncTaskExit(1, taskletClassName, title, object);
            Object retVal = keepalive.invokeExitOnClient(exit);
            if (retVal != null) {
                Trace.trace(TRACE_MASKF, "return value from exit: " + retVal);
                if (retVal instanceof IllegalStateException) {
                    throw (IllegalStateException)retVal;
                }
                if (retVal instanceof Throwable) {
                    throw new HException((Throwable)retVal);
                }
            }
        } else {
            throw new IllegalStateException("Keep alive tasklet not initialized yet; to early for this call");
        }
        Trace.trace(TRACE_MASKT, "<- AsyncTask.startLocalTask()");
    }

    public static void startAsyncTask(Tasklet tasklet, String taskletClassName, LocalizableText title, Object object) throws HException {
        Trace.trace(TRACE_MASKT, "-> AsyncTask.startAsyncTask(tasklet)");
        AsyncTaskExit exit = new AsyncTaskExit(2, taskletClassName, title, object);
        Object retVal = tasklet.invokeExitOnClient(exit);
        if (retVal != null) {
            Trace.trace(TRACE_MASKF, "return value from exit: " + retVal);
            if (retVal instanceof IllegalStateException) {
                throw (IllegalStateException)retVal;
            }
            if (retVal instanceof Throwable) {
                throw new HException((Throwable)retVal);
            }
        }
        Trace.trace(TRACE_MASKT, "<- AsyncTask.startAsyncTask(tasklet)");
    }

    public static void startAsyncTasks(String taskletClassName, LocalizableText title, Object object) throws HException {
        Trace.trace(TRACE_MASKT, "-> AsyncTask.startAsyncTasks()");
        Tasklet keepalive = KeepAliveTasklet.tasklet;
        if (keepalive != null) {
            AsyncTaskExit exit = new AsyncTaskExit(3, taskletClassName, title, object);
            Object retVal = keepalive.invokeExitOnClient(exit);
            if (retVal != null) {
                Trace.trace(TRACE_MASKF, "return value from exit: " + retVal);
                if (retVal instanceof IllegalStateException) {
                    throw (IllegalStateException)retVal;
                }
                if (retVal instanceof Throwable) {
                    throw new HException((Throwable)retVal);
                }
            }
        } else {
            throw new IllegalStateException("Keep alive tasklet not initialized yet; to early for this call");
        }
        Trace.trace(TRACE_MASKT, "<- AsyncTask.startAsyncTasks()");
    }

    public static void startAsyncTask(HMCSession session, String taskletClassName, LocalizableText title, Object object) throws HException {
        Trace.trace(TRACE_MASKT, "-> AsyncTask.startAsyncTask(session)");
        if (session == null) {
            Trace.trace(TRACE_MASKF, "session is null");
            throw new NullPointerException("Session is null");
        }
        TaskLauncher.startTask(new AsyncTaskParms(taskletClassName, title, object), (class$com$ibm$hwmca$fw$task$AsyncTask == null ? (class$com$ibm$hwmca$fw$task$AsyncTask = AsyncTask.class$("com.ibm.hwmca.fw.task.AsyncTask")) : class$com$ibm$hwmca$fw$task$AsyncTask).getName(), session, false, session.getUserContext());
        Trace.trace(TRACE_MASKF, "task successfully started");
        Trace.trace(TRACE_MASKT, "<- AsyncTask.startAsyncTask(session)");
    }

    public AsyncTask(AsyncTaskParms parms) throws TaskletException {
        super(parms, "");
        Trace.trace(TRACE_MASKF, "-> AsyncTask constructor");
        Trace.trace(TRACE_MASKF, "using tasklet: " + parms.taskletClassName);
        this.setInitiatingTaskletName(parms.taskletClassName);
        this.setInitialData(ASYNC_TASK_OBJECT_KEY, parms.initialObject);
        Trace.trace(TRACE_MASKF, "<- AsyncTask constructor");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKF, "-> AsyncTask.logException()");
        Trace.trace(TRACE_MASKF, "processing exception: " + throwable);
        Trace.trace(TRACE_MASKF, "<- AsyncTask.logException()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AsyncTaskParms
    extends PresentationTaskParms {
        private String taskletClassName = null;
        private Object initialObject = null;

        private AsyncTaskParms(String taskletClassName, LocalizableText title, Object object) {
            this.taskletClassName = taskletClassName;
            this.initialObject = object;
            this.setUIInfo(new UIInfo(title, new LocalizableText("")));
        }
    }

    private static class AsyncTaskExit
    implements TaskletClientExitInterface {
        private int type;
        private String taskletClassName;
        private Object exitReturn = null;
        private LocalizableText title;
        private Object initialObject = null;

        private AsyncTaskExit(int type, String taskletClassName, LocalizableText title, Object object) {
            this.type = type;
            this.taskletClassName = taskletClassName;
            this.title = title;
            this.initialObject = object;
            Trace.trace(AsyncTask.TRACE_MASKF, "<> AsyncTaskExit.ctor()");
        }

        public Object exit() {
            Trace.trace(AsyncTask.TRACE_MASKF, "-> AsyncTaskExit.exit()");
            this.exitReturn = null;
            try {
                HMCSession session = null;
                PanelModelTaskPortal portal = null;
                Collection allSessions = null;
                switch (this.type) {
                    case 1: {
                        Trace.trace(AsyncTask.TRACE_MASKF, "handling local type");
                        allSessions = HMCSession.getAllSessions();
                        if (allSessions != null) {
                            Iterator i = allSessions.iterator();
                            while (i.hasNext() && session == null) {
                                HMCSession tmpSession = (HMCSession)i.next();
                                if (tmpSession == null || tmpSession.isDisconnected()) continue;
                                ClientUserContext userContext = tmpSession.getUserContext();
                                try {
                                    if (userContext == null || !userContext.isLocalContext()) continue;
                                    session = tmpSession;
                                }
                                catch (UnknownHostException e) {
                                    Trace.trace(AsyncTask.TRACE_MASKF, "ignoring the following exception");
                                    Trace.trace(AsyncTask.TRACE_MASKF, e);
                                }
                            }
                        } else {
                            Trace.trace(AsyncTask.TRACE_MASKF, "session collection is null");
                        }
                        if (session != null) {
                            Trace.trace(AsyncTask.TRACE_MASKF, "found local session; starting task");
                            TaskLauncher.startTask(new AsyncTaskParms(this.taskletClassName, this.title, this.initialObject), (class$com$ibm$hwmca$fw$task$AsyncTask == null ? (class$com$ibm$hwmca$fw$task$AsyncTask = AsyncTask.class$("com.ibm.hwmca.fw.task.AsyncTask")) : class$com$ibm$hwmca$fw$task$AsyncTask).getName(), session, false, session.getUserContext());
                            Trace.trace(AsyncTask.TRACE_MASKF, "task successfully started");
                            break;
                        }
                        Trace.trace(AsyncTask.TRACE_MASKF, "local session not found");
                        this.exitReturn = new IllegalStateException("Invalid state; no local session or local session disconnected");
                        break;
                    }
                    case 2: {
                        portal = PanelModel.getThreadLocalPanelModelTaskPortal();
                        if (portal != null) {
                            session = portal.getHMCSession();
                            if (session != null) {
                                Trace.trace(AsyncTask.TRACE_MASKF, "found tasklet session; starting task");
                                TaskLauncher.startTask(new AsyncTaskParms(this.taskletClassName, this.title, this.initialObject), (class$com$ibm$hwmca$fw$task$AsyncTask == null ? (class$com$ibm$hwmca$fw$task$AsyncTask = AsyncTask.class$("com.ibm.hwmca.fw.task.AsyncTask")) : class$com$ibm$hwmca$fw$task$AsyncTask).getName(), session, false, session.getUserContext());
                                Trace.trace(AsyncTask.TRACE_MASKF, "task successfully started");
                                break;
                            }
                            Trace.trace(AsyncTask.TRACE_MASKF, "tasklet session not found");
                            this.exitReturn = new IllegalStateException("Invalid state; tasklet session not found");
                            break;
                        }
                        Trace.trace(AsyncTask.TRACE_MASKF, "tasklet portal not found");
                        this.exitReturn = new IllegalStateException("Invalid state; tasklet portal not found");
                        break;
                    }
                    case 3: {
                        Trace.trace(AsyncTask.TRACE_MASKF, "handling all type");
                        allSessions = HMCSession.getAllSessions();
                        if (allSessions != null) {
                            Iterator i = allSessions.iterator();
                            while (i.hasNext() && session == null) {
                                HMCSession tmpSession = (HMCSession)i.next();
                                if (tmpSession == null) continue;
                                Trace.trace(AsyncTask.TRACE_MASKF, "found a session; starting task: " + tmpSession);
                                TaskLauncher.startTask(new AsyncTaskParms(this.taskletClassName, this.title, this.initialObject), (class$com$ibm$hwmca$fw$task$AsyncTask == null ? AsyncTask.class$("com.ibm.hwmca.fw.task.AsyncTask") : class$com$ibm$hwmca$fw$task$AsyncTask).getName(), tmpSession, false, tmpSession.getUserContext());
                                Trace.trace(AsyncTask.TRACE_MASKF, "task successfully started");
                            }
                            break;
                        }
                        Trace.trace(AsyncTask.TRACE_MASKF, "session collection is null");
                        break;
                    }
                    default: {
                        Trace.trace(AsyncTask.TRACE_MASKF, "invalid task type " + this.type + " specified");
                        this.exitReturn = new IllegalArgumentException("Invalid task type '" + this.type + "' specified");
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(AsyncTask.TRACE_MASKF, "Sending the following exception back to the caller");
                Trace.trace(AsyncTask.TRACE_MASKF, e);
                this.exitReturn = e;
            }
            Trace.trace(AsyncTask.TRACE_MASKF, "<- AsyncTaskExit.exit()");
            return this.exitReturn;
        }
    }
}

